#version 330
#extension GL_EXT_gpu_shader4 : enable
//Space MonolithMod01.fsh    by   zackpudil
//https://www.shadertoy.com/view/4sVXzK
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


const float tmax = 20.0;

float map(vec3 p) {
	p.xy = mod(p.xy + 1.0, 2.0) - 1.0;
	p.z = abs(p.z) - 0.75;
	vec4 q = vec4(p, 1.0);
	
	for(int i = 0; i < 15; i++) {
		q.xyz = abs(q.xyz) - vec3(0.3, 1.0, -0.0);
		q = 2.0*q/clamp(dot(q.xyz, q.xyz), 0.5, 1.0) - vec4(1.0, 0.0, 0.3, 0.0);
	}
	
	return abs(q.x + q.y + q.z)/q.w;
}

vec2 march(vec3 ro, vec3 rd) {
	float d = 1.0;
	float e, t = 0.0;
    float g = 0.0;
	
	for(int i = 0; i < 200; i++) {
		if(abs(d) < e || t >= tmax) break;
		d = map(ro + rd*t);
		e = 0.001*(1.0 + t*4.0);
		t += d*(0.55 + 0.05*t);
        
        g = 1.0;
	}
	
	return vec2(t, t >= tmax ? 0.0 :clamp(g*0.9, 0.0, 1.0));
}

vec3 normal(vec3 p) {
	vec2 h = vec2(0.01, 0.0);
	vec3 n = vec3(
		map(p + h.xyy) - map(p - h.xyy),
		map(p + h.yxy) - map(p - h.yxy),
		map(p + h.yyx) - map(p - h.yyx)
	);
	return normalize(n);
}

mat3 camera(vec3 eye, vec3 lat) {
	vec3 ww = normalize(lat - eye);
	vec3 uu = normalize(cross(vec3(0, 1, 0), ww));
	vec3 vv = normalize(cross(ww, uu));
	
	return mat3(uu, vv, ww);
}

float hash2(vec2 n) {
	return fract(sin(dot(n, vec2(27.233, 71.989)))*43758.5453);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
	vec2 uv = -1.0 + 2.0*(gl_FragCoord.xy/iResolution.xy);
	uv.x *= iResolution.x/iResolution.y;
	
	vec3 col = vec3(1)*step(0.997, hash2(uv));
	
	vec3 ro = vec3(iTime*0.5, 1.0*sin(iTime*0.3), 0.25*cos(iTime*0.2));
	vec3 rd = normalize(camera(ro, ro + vec3(3.0, 0, 4.0*sin(iTime*0.5)))*vec3(uv, 1.97));
    
    vec3 pos;
	
	vec2 i = march(ro, rd);
	if(i.x < tmax) {
		pos = ro + rd*i.x;
		vec3 nor = normal(pos);

		col = vec3(0.0);

		col += 0.1*pow(clamp(1.0 + dot(rd, nor), 0.0, 1.0), 2.0)*smoothstep(-8.0, -6.0, -i.x);
	}

	float y = mod(pos.y + iTime, 2.0);
    col += pow(abs(i.y), 0.3)
        *vec3(1.0, 0, 0)
        *smoothstep(0.0, 0.2, y)
		*smoothstep(-0.2, 0.0, -y);
	col = pow(col, vec3(.454545));
	
	gl_FragColor = vec4(col, 1);
}